﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Configuration;
using ZSMusic.BLL;
using ZSMusic.Model;

namespace WEB
{
    public static class Settings
    {
        public static bool Pass(System.Web.UI.Page page)
        {

            bool free = ConfigurationManager.AppSettings["IsFree"] == "1" ||
                ConfigurationManager.AppSettings["IsNeedDB"] == "0" ||
                page.Request["apikey"] == ConfigurationManager.AppSettings["AdminPwd"];
            if (free)
            { return true; }
            else
            {
                string key = page.Request["apikey"];
                if (!UserBLL.Exists(key))
                { throw new Exception("该ApiKey不存在"); }
                //User u = UserBLL.GetModelById(key);
                //if (u.Balance <= 0)
                //{ throw new Exception("该ApiKey额度已用尽"); }
                return true;
            }
        }

        public static string AdminPwd
        {
            get { return ConfigurationManager.AppSettings["AdminPwd"]; }
        }

        public static long PreBalance
        {
            get { return Convert.ToInt64(ConfigurationManager.AppSettings["PreBalance"]); }
        }

        /// <summary>
        /// 获取客户端IP
        /// </summary>
        public static string ClientIP
        {
            get
            {
                string result = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
                if (null == result || result == String.Empty)
                {
                    result = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
                }
                if (null == result || result == String.Empty)
                {
                    result = HttpContext.Current.Request.UserHostAddress;
                }
                return result;
            }
        }

    }
}